/***************************************
 *                                     *
 * ļ: 02 Ա\01 SequenceList *
 *                                     *
 * ļ: SequenceList.c              *
 *                                     *
 *   : 2.32.42.52.6          * 
 *                                     *
 ***************************************/

#ifndef SEQUENCELIST_C
#define SEQUENCELIST_C

#include "SequenceList.h" 				//**02 Ա**//

/*TTTT[
U㷨2.3 U 
^TTTT*/
Status InitList_Sq(SqList *L)
{
	(*L).elem = (LElemType_Sq*)malloc(LIST_INIT_SIZE*sizeof(LElemType_Sq));
	if(!(*L).elem)
		exit(OVERFLOW); 				//ڴʧ

	(*L).length = 0;					//ʼ˳Ϊ0
	(*L).listsize = LIST_INIT_SIZE;		//˳ʼڴ

	return OK;							//ʼɹ	 
} 

void ClearList_Sq(SqList *L)
{
	(*L).length = 0;
}

void DestroyList_Sq(SqList *L)
{
	free((*L).elem);

	(*L).elem = NULL;					//ͷڴÿָ 
	(*L).length = 0;
	(*L).listsize = 0;
}

Status ListEmpty_Sq(SqList L)
{
	return 	L.length==0 ? TRUE : FALSE;
}

int ListLength_Sq(SqList L)
{
	return L.length;	
}

Status GetElem_Sq(SqList L, int i, LElemType_Sq *e)
{ 
	if(i<1 || i>L.length)
		return ERROR;					//iֵϷ
	else
		*e = L.elem[i-1];

	return OK;
}

/*TTTT[
U㷨2.6 U 
^TTTT*/
int LocateElem_Sq(SqList L, LElemType_Sq e, Status(Compare)(LElemType_Sq, LElemType_Sq))
{
	int i = 1;							//iĳֵΪһԪصλ
	
	while(i<=L.length && !Compare(e, L.elem[i-1]))
		++i;

	if(i<=L.length)
		return i;
	else
		return 0; 
}

Status PriorElem_Sq(SqList L, LElemType_Sq cur_e, LElemType_Sq *pre_e)
{
	int i = 1;
	
	if(L.elem[0]!=cur_e)				//һǰ 
	{
		while(i<L.length && L.elem[i]!=cur_e)
			++i;
		
		if(i<L.length)
		{
			*pre_e = L.elem[i-1];
			return OK;
		}	
	}
			
	return ERROR;
}

Status NextElem_Sq(SqList L, LElemType_Sq cur_e, LElemType_Sq *next_e)
{
	int i = 0;
	
	while(i<L.length && L.elem[i]!=cur_e)
		++i;

	if(i<L.length-1)					//һ޺ 
	{
		*next_e = L.elem[i+1];	
		return OK;
	}

	return ERROR;
}

/*TTTT[
U㷨2.4 U 
^TTTT*/
Status ListInsert_Sq(SqList *L, int i, LElemType_Sq e)
{
	LElemType_Sq *newbase; 
	LElemType_Sq *p, *q;

	if(i<1 || i>(*L).length+1)
		return ERROR;					//iֵϷ

	if((*L).length >= (*L).listsize)	//洢ռ迪¿ռ 
	{
		newbase = (LElemType_Sq*)realloc((*L).elem, ((*L).listsize+LISTINCREMENT)*sizeof(LElemType_Sq));
		if(!newbase)
			exit(OVERFLOW);

		(*L).elem = newbase;
		(*L).listsize += LISTINCREMENT;
	}
	
	q = &(*L).elem[i-1];				//qΪλ 
	
	for(p=&(*L).elem[(*L).length-1]; p>=q; --p)
		*(p+1) = *p;					//λü֮Ԫ 
	
	*q = e;								//e 
	(*L).length++;						//1

	return OK; 
}

/*TTTT[
U㷨2.5 U 
^TTTT*/
Status ListDelete_Sq(SqList *L, int i, LElemType_Sq *e)
{
	LElemType_Sq *p, *q;
		
	if(i<1 || i>(*L).length)
		return ERROR;					//iֵϷ
	
	p = &(*L).elem[i-1];				//pΪɾԪصλ 
	*e = *p;
	q = (*L).elem+(*L).length-1; 		//βԪλ 
	
	for(++p; p<=q; ++p)
		*(p-1) = *p;					//ɾԪ֮Ԫ 

	(*L).length--;						//1

	return OK;
}

Status ListTraverse_Sq(SqList L, void(Visit)(LElemType_Sq))
{
	int i;

	for(i=0; i<L.length; i++)
		Visit(L.elem[i]);
	
	return OK;
}

#endif
